import numpy as np
import scipy.signal as sig

def create_time_data(num, samp_freq):
    
    delta_t = 1./samp_freq
    start, stop = 0, (num-1)*delta_t

    t = np.linspace(start, stop, num)

    return t


def create_waveform_data(t, a, f, shape):

    num = len(t)

    if shape == 'Sine':
        y = a*np.sin(2*np.pi*f*t)
    elif shape == 'Cosine':
        y = a*np.cos(2*np.pi*f*t)
    elif shape == 'DC Level':
        y = a*np.ones(num)
    elif shape == 'Square':
        y = a*sig.square(2*np.pi*f*t)
    elif shape == 'Sawtooth':
        y = a*sig.sawtooth(2*np.pi*f*t, 1.0)
    elif shape == 'Triangle':
        y = a*sig.sawtooth(2*np.pi*f*t, 0.5)
    elif shape == 'User-Defined':
        y = (8/np.pi**2)*(np.sin(2*np.pi*t)
             - (1/9)*np.sin(6*np.pi*t)
             + (1/25)*np.sin(10*np.pi*t)
             - (1/49)*np.sin(14*np.pi*t))

    return y


def sum_sines(t, num_terms):

    num = len(t)
    y = np.zeros(num)
    largest_odd = 2*num_terms + 1

    for odd in range(1, largest_odd, 2):
       y += (1/odd)*np.sin(2*np.pi*odd*t)
    y = (4/np.pi)*y

    return y



if __name__ == '__main__':

    import matplotlib.pyplot as plt

    num, samp_freq = 100, 100
    a, f = 5, 3
    shape = 'Sine'
    
    t = create_time_data(num, samp_freq)
    y = create_waveform_data(t, a, f, shape)
    
    plt.plot(t, y)
    plt.show()
